/* ------------------------------------------------------------------------------
  File: CHR_LSM303.c
  Author: CH Robotics
  Version: 1.0
  
  Description: Functions for interacting with HMC5843 magnetic sensor
------------------------------------------------------------------------------ */ 

#include "stm32f10x.h"
#include "CHR_LSM303.h"
#include "CHR_i2c.h"

/*******************************************************************************
* Function Name  : initializeLSM
* Input          : None
* Output         : uint8_t* status_flag
* Return         : 1 if success, 0 if fail
* Description    : Initializes the LSM303 accelerometer
						 
*******************************************************************************/
int32_t initializeLSM( uint8_t* status_flag )
{
	 uint8_t returnval;
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG1_A;
	 g_i2cTxBuf[1] = 0x27;	// Normal power mode, 50 Hz update rate, all channels enabled
	 
	 returnval = i2cBatchWrite( LSM_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG2_A;
	 g_i2cTxBuf[1] = 0x00; // No high-pass filter, no manual reboot (at the moment...)
	 
	 returnval = i2cBatchWrite( LSM_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG3_A;
	 g_i2cTxBuf[1] = 0x82;	// Active-low interrupts, data ready routed to interrupt pin 1
	 
	 returnval = i2cBatchWrite( LSM_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG4_A;
	 g_i2cTxBuf[1] = 0x00;	// 2 g full-scale range
	 
	 returnval = i2cBatchWrite( LSM_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 return 1;
	 
	 /*
	 g_i2cTxBuf[0] = LSM_CTRL_REG1_A;
	 g_i2cTxBuf[1] = 0x27;	// Normal power mode, 50 Hz update rate, all channels enabled
	 
	 g_i2cCurrentSlaveAddress = LSM_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cBytesToTransmit = 2;
	 g_i2cReadPrelude = 0;
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG2_A;
	 g_i2cTxBuf[1] = 0x00; // No high-pass filter, no manual reboot (at the moment...)
	 
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG3_A;
	 g_i2cTxBuf[1] = 0x82;	// Active-low interrupts, data ready routed to interrupt pin 1
	 
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 
	 g_i2cTxBuf[0] = LSM_CTRL_REG4_A;
	 g_i2cTxBuf[1] = 0x00;	// 2 g full-scale range
	 
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 
	 
	 return 1;
	 */
}

/*******************************************************************************
* Function Name  : getLSMData
* Input          : None
* Output         : uint8_t* i2cBuf
* Return         : 1 if success, 0 if fail
* Description    : 
*******************************************************************************/
int32_t getLSMData( uint8_t* i2cBuf )
{
	 int32_t returnval;
	 
	 int i;
	 
	 i2cBatchRead( LSM_SLAVE_ADDRESS7, (LSM_OUT_X_L | 0x80), g_i2cRxBuf, 6 );
	 
	 return 1;
	 
	 /*
	 // Send START condition
	 I2C_GenerateSTART(I2C1, ENABLE);

	 // Wait for START condition to transmit
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_MODE_SELECT) )
	 {
		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Send slave address
	 I2C_Send7bitAddress(I2C1, LSM_SLAVE_ADDRESS7, I2C_Direction_Transmitter);

	 // Wait for ACK
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED) )
	 {
		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Send address of x-axis accel low byte along with flag to indicate that we are going to keep reading data
	 I2C_SendData(I2C1, (LSM_OUT_X_L | 0x80) );

	 // Wait for ACK
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_BYTE_TRANSMITTED) )
	 {
		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Start reading	 
	 returnval = i2cRead( LSM_SLAVE_ADDRESS7, i2cBuf, 6 );

	 if( !returnval )
	 {
		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 else
	 {
		  return 1;
	 }
	 */
	 
	 return 1;
}
